/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Triffid
extends EntityLiving {
    private int closedcount = 0;

    public Triffid(World w) {
        super(w);
        this.maxrenderdist = 180;
        this.height = 5.33f;
        this.width = 1.75f;
        this.uniquename = "OreSpawn:Triffid";
        this.moveSpeed = 0.03f;
        this.setMaxHealth(200.0f);
        this.setHealth(200.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(30.0f);
        this.searchDistance = 16.0f;
        this.attackRange = 5.0f;
        this.movefrequency = 85;
        this.setExperience(199);
        this.canSwim = false;
        this.isImmuneToFire = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 10) {
            return;
        }
        if (this.closedcount > 0) {
            return;
        }
        this.closedcount = 100 + this.world.rand.nextInt(200);
        super.doAttackFrom(e, dt, pain);
    }

    public boolean getOpenClosed() {
        return this.getVarInt(21) > 0;
    }

    public void doEntityAction(float deltaT) {
        if (this.closedcount > 0) {
            if (this.getVarInt(21) <= 0) {
                this.setVarInt(21, 1);
            }
            --this.closedcount;
        } else if (this.getVarInt(21) != 0) {
            this.setVarInt(21, 0);
        }
        if (this.world.rand.nextInt(10) == 1) {
            int bid;
            double ix = this.posx;
            double iz = this.posz;
            int k = -6;
            while (k <= 6) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - 1.0), (int)this.posz + k);
                if (bid != 0) {
                    if (k < 0) {
                        iz -= 1.0;
                    }
                    if (k > 0) {
                        iz += 1.0;
                    }
                }
                ++k;
            }
            k = -6;
            while (k <= 6) {
                bid = this.world.getblock(this.dimension, (int)this.posx + k, (int)(this.posy - 1.0), (int)this.posz);
                if (bid != 0) {
                    if (k < 0) {
                        ix -= 1.0;
                    }
                    if (k > 0) {
                        ix += 1.0;
                    }
                }
                ++k;
            }
            if (this.target == null) {
                this.target = new TargetHelper(null, ix, this.posy, iz);
            }
            this.target.setTarget(ix, this.posy, iz);
            this.moveTowardsTarget(deltaT);
        }
        super.doEntityAction(deltaT);
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "OreSpawn:triffid_living";
    }

    public String getHurtSound() {
        return "OreSpawn:triffid_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:triffid_dead";
    }

    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.greengoo.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(6) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophytriffid.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Triffid) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Triffidtexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }
}

